/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.base.connectors;

import data.base.Database;
import data.base.NoBaseException;

import data.structures.tagging.LemmaInfos;
import data.structures.tagging.LemmaItem;
import data.structures.tagging.LemmaVector;
import data.structures.thema.ThemaItem;

import proc.text.Codecs;
import proc.tagging.TreeTagger;

import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/**
 *
 * @author claitang1
 */
public class ThesaurusDatabase {
    private Database theDB;
    //private List ignoreLemma;

    public ThesaurusDatabase(Database db){
        theDB = db;
        /*ignoreLemma = new ArrayList();
        try {
            getIgnoreLemma();
        } catch (SQLException ex) {
            ex.printStackTrace();
        }*/
    }

    /*public int saveConcept(String ConceptName, String ConceptDesc, int ThesaurusID)
    {
        String query = String.format("INSERT INTO tax_classes(taxonomie, titleFR, descriptionFR)  VALUES("+ThesaurusID+", '%s', '%s')",
                Codecs.escapeHTML(ConceptName),
                Codecs.escapeHTML(ConceptDesc));
        return theDB.executeInsertOrUpdate(query);
    }*/

    /*public int saveRelationship(String ConceptID1, String ConceptID2)
    {
        String query = String.format("INSERT INTO ipri_thematique(ConceptID1, RelationType, ConceptID2, idSemantic_ressources)  VALUES("+ConceptID1+", 'hierarchie', "+ConceptID2+", 1)");
        return theDB.executeInsertOrUpdate(query);
    }*/

    public Set<ThemaItem> getAllClasses() throws NoBaseException {
        String query = String.format("SELECT * FROM tax_classes;");
        ResultSet rs = theDB.executeSelection(query);
        Set<ThemaItem> items = new LinkedHashSet<ThemaItem>();
        try {
            while (rs.next()) {
                ThemaItem ti = new ThemaItem();
                ti.setConceptID(rs.getInt("id"));
                ti.setConceptName(Codecs.desEscapeHTML(rs.getString("titreFR")));
                ti.setConceptDesc(Codecs.desEscapeHTML(rs.getString("descriptionFR")));
                ti.setThesaurusID(rs.getInt("taxonomie"));
                ti.setTitleLemmas(Codecs.desEscapeHTML(rs.getString("titreLemmaFR")));
                ti.setDescLemmas(Codecs.desEscapeHTML(rs.getString("descLemmaFR")));
                items.add(ti);
            }
        } catch (SQLException e) {
            System.out.println("error on get thema last key " + e.toString());
        }
        return items;
    }

    public Set<ThemaItem> getAllClasses(int taxonomie) throws NoBaseException {
        String query = String.format("SELECT * FROM tax_classes WHERE taxonomie="+taxonomie+";");
        ResultSet rs = theDB.executeSelection(query);
        Set<ThemaItem> items = new LinkedHashSet<ThemaItem>();
        try {
            while (rs.next()) {
                ThemaItem ti = new ThemaItem();
                ti.setConceptID(rs.getInt("id"));
                ti.setConceptName(Codecs.desEscapeHTML(rs.getString("titreFR")));
                ti.setConceptDesc(Codecs.desEscapeHTML(rs.getString("descriptionFR")));
                ti.setThesaurusID(rs.getInt("taxonomie"));
                ti.setTitleLemmas(Codecs.desEscapeHTML(rs.getString("titreLemmaFR")));
                ti.setDescLemmas(Codecs.desEscapeHTML(rs.getString("descLemmaFR")));
                items.add(ti);
            }
        } catch (SQLException e) {
            System.out.println("error on get thema last key " + e.toString());
        }
        return items;
    }

    private Map<Integer, ThemaItem> concepts = new HashMap<Integer, ThemaItem>();
    public ThemaItem getClasse(int id) throws NoBaseException {
        ThemaItem item = concepts.get(new Integer(id));
        if (item == null) {
            String query = String.format("SELECT * FROM tax_classes WHERE id=" + id + ";");
            ResultSet rs = theDB.executeSelection(query);
            item = new ThemaItem();
            try {
                while (rs.next()) {
                    ThemaItem ti = new ThemaItem();
                    ti.setConceptID(rs.getInt("id"));
                    ti.setConceptName(Codecs.desEscapeHTML(rs.getString("titreFR")));
                    ti.setConceptDesc(Codecs.desEscapeHTML(rs.getString("descriptionFR")));
                    ti.setThesaurusID(rs.getInt("taxonomie"));
                    ti.setTitleLemmas(Codecs.desEscapeHTML(rs.getString("titreLemmaFR")));
                    ti.setDescLemmas(Codecs.desEscapeHTML(rs.getString("descLemmaFR")));
                    item = ti;
                }
            } catch (SQLException e) {
                System.out.println("error on get thema last key " + e.toString());
            }
            concepts.put(new Integer(id), item);
        }
        return item;
    }

    public Set<LemmaItem> getLemmas(int classe) throws NoBaseException {
        //populate the graph with associated lemmas
        String query = String.format("SELECT * FROM tax_lemmesfr WHERE classe="+classe+";");
        Set<LemmaItem> lemmas = new HashSet<LemmaItem>();
        ResultSet lemmasRS = theDB.executeSelection(query);
        try{
            while (lemmasRS.next()) {
               LemmaItem li = new LemmaItem();
               li.setLemmaName(Codecs.desEscapeHTML(lemmasRS.getString("lemme")));
               li.setNodeID(lemmasRS.getInt("classe"));
               li.setCountTitle(lemmasRS.getInt("occuTitre"));
               li.setCountDesc(lemmasRS.getInt("occuDesc"));
               lemmas.add(li);
            }
        } catch (SQLException e) {
            System.out.println("error " + e.toString());
        }
        return lemmas;
    }

    public Set<LemmaItem> getExtendedLemmas(int classe) throws NoBaseException {
        Set<LemmaItem> lemmas = new HashSet<LemmaItem>();
        lemmas.addAll(getLemmas(classe));
        Vector<ThemaItem> v = new Vector<ThemaItem>(getSubclasses(classe));
        for(int i=0; i<v.size(); i++){
            lemmas.addAll(getExtendedLemmas(v.elementAt(i).getConceptID()));
        }
        return lemmas;
    }

    public Set<LemmaItem> getOnlyExtendedLemmas(int classe) throws NoBaseException {
        Set<LemmaItem> lemmas = new HashSet<LemmaItem>();
        //lemmas.addAll(getLemmas(conceptID));
        Vector<ThemaItem> v = new Vector<ThemaItem>(getSubclasses(classe));
        for(int i=0; i<v.size(); i++){
            lemmas.addAll(getExtendedLemmas(v.elementAt(i).getConceptID()));
        }
        return lemmas;
    }

    public Set<ThemaItem> getSuperclasses(int classe) throws NoBaseException {
        //populate the set with the parent items
        String parentNodeQuery = String.format("SELECT t.id, t.titreFR, t.descriptionFR," +
                "t.taxonomie, t.titreLemmaFR, t.descLemmaFR " +
                "FROM tax_hierarchie r, tax_classes t WHERE r.sousClasse = "+classe+" " +
                "AND t.id = r.surClasse;");
        Set<ThemaItem> parentItems = new HashSet<ThemaItem>();
        ResultSet parentRS = theDB.executeSelection(parentNodeQuery);
        try {
            while (parentRS.next()) {
                ThemaItem ti = new ThemaItem();
                ti.setConceptID(parentRS.getInt("id"));
                ti.setConceptName(Codecs.desEscapeHTML(parentRS.getString("titreFR")));
                ti.setConceptDesc(Codecs.desEscapeHTML(parentRS.getString("descriptionFR")));
                ti.setThesaurusID(parentRS.getInt("taxonomie"));
                ti.setTitleLemmas(Codecs.desEscapeHTML(parentRS.getString("titreLemmaFR")));
                ti.setDescLemmas(Codecs.desEscapeHTML(parentRS.getString("descLemmaFR")));
               parentItems.add(ti);
            }
        } catch (SQLException e) {
            System.out.println("error on get thema last key " + e.toString());
        }
        return parentItems;
    }

    public Set<ThemaItem> getSubclasses(int classe) throws NoBaseException {
        //populate the set with the child items
        String childNodeQuery = String.format("SELECT t.id, t.titreFR, t.descriptionFR," +
                "t.taxonomie, t.titreLemmaFR, t.descLemmaFR " +
                "FROM tax_hierarchie r, tax_classes t WHERE r.surClasse = "+classe+" " +
                "AND t.id = r.sousClasse;");
        Set<ThemaItem> childItems = new HashSet<ThemaItem>();
        ResultSet childRS = theDB.executeSelection(childNodeQuery);
        try {
            while (childRS.next()) {
                ThemaItem ti = new ThemaItem();
                ti.setConceptID(childRS.getInt("id"));
                ti.setConceptName(Codecs.desEscapeHTML(childRS.getString("titreFR")));
                ti.setConceptDesc(Codecs.desEscapeHTML(childRS.getString("descriptionFR")));
                ti.setThesaurusID(childRS.getInt("taxonomie"));
                ti.setTitleLemmas(Codecs.desEscapeHTML(childRS.getString("titreLemmaFR")));
                ti.setDescLemmas(Codecs.desEscapeHTML(childRS.getString("descLemmaFR")));
                childItems.add(ti);
            }
        } catch (SQLException e) {
            System.out.println("error on get thema last key " + e.toString());
        }
        return childItems;
    }

    private Set<ThemaItem> topClasses;
    public Set<ThemaItem> getTopClasses() throws NoBaseException {
        if (topClasses == null) {
            topClasses = new HashSet<ThemaItem>();
            Vector<ThemaItem> tout = new Vector(getAllClasses());
            for (int i = 0; i < tout.size(); i++) {
                String parentNodeQuery = String.format("SELECT t.id " +
                        "FROM tax_hierarchie r, tax_classes t WHERE r.sousClasse = " +
                        tout.elementAt(i).getConceptID() +
                        " AND t.id = r.surClasse;");
                ResultSet parentRS = theDB.executeSelection(parentNodeQuery);
                try {
                    if (parentRS.next()) {
                        // Il y a un parent, donc ce n'est pas un concept du top
                    } else {
                        topClasses.add(tout.elementAt(i));
                    }
                } catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
            }
        }
        return topClasses;
    }

    private Set<ThemaItem> topClasses2;
    public Set<ThemaItem> getTopClasses(int taxonomie) throws NoBaseException {
        if (topClasses2 == null) {
            topClasses2 = new HashSet<ThemaItem>();
            Vector<ThemaItem> tout = new Vector(getAllClasses(taxonomie));
            for (int i = 0; i < tout.size(); i++) {
                String parentNodeQuery = String.format("SELECT t.id " +
                        "FROM tax_hierarchie r, tax_classes t WHERE r.sousClasse = " +
                        tout.elementAt(i).getConceptID() +
                        " AND t.id = r.surClasse;");
                ResultSet parentRS = theDB.executeSelection(parentNodeQuery);
                try {
                    if (parentRS.next()) {
                        // Il y a un parent, donc ce n'est pas un concept du top
                    } else {
                        topClasses2.add(tout.elementAt(i));
                    }
                } catch (SQLException sqle) {
                    sqle.printStackTrace();
                }
            }
        }
        return topClasses2;
    }

    public String[] getNomsTopThematiques() throws NoBaseException {
        Vector<ThemaItem> result = new Vector(getTopClasses());
        String[] res = new String[result.size()];
        for(int i=0; i<res.length; i++){
            res[i] = result.elementAt(i).getConceptName();
        }
        return res;
    }

    public String[] getNomsTopThematiques(int taxonomie) throws NoBaseException {
        Vector<ThemaItem> result = new Vector(getTopClasses(taxonomie));
        String[] res = new String[result.size()];
        for(int i=0; i<res.length; i++){
            res[i] = result.elementAt(i).getConceptName();
        }
        return res;
    }

    public void resetTaxonomie(int id) throws NoBaseException {
        String removeRelations = "DELETE FROM tax_hierarchie WHERE surClasse IN (SELECT id FROM tax_classes WHERE taxonomie="+id+");";
        theDB.executeDeletion(removeRelations);
        String removeRelations2 = "DELETE FROM tax_hierarchie WHERE sousClasse IN (SELECT id FROM tax_classes WHERE taxonomie="+id+");";
        theDB.executeDeletion(removeRelations2);
        String removeLemmes = "DELETE FROM tax_lemmesFR WHERE classe IN (SELECT id FROM tax_classes WHERE taxonomie="+id+");";
        theDB.executeDeletion(removeLemmes);
        String removeLemmes2 = "DELETE FROM tax_lemmesEN WHERE classe IN (SELECT id FROM tax_classes WHERE taxonomie="+id+");";
        theDB.executeDeletion(removeLemmes2);
        String removeConcepts = "DELETE FROM tax_classes WHERE taxonomie="+id+";";
        theDB.executeDeletion(removeConcepts);
    }

    private TreeTagger tt = new TreeTagger();
    private TreeTagger tte = new TreeTagger(TreeTagger.EN);

    public void storeClasse(int taxonomie, int id, String nomEN, String descEN,
            String nomFR, String descFR, int parent) throws NoBaseException {
        LemmaVector lemmasNomFR = tt.processText(nomFR);
        LemmaVector lemmasDescFR = tt.processText(descFR);
        LemmaVector lemmasNomEN = tte.processText(nomEN);
        LemmaVector lemmasDescEN = tte.processText(descEN);
        if(parent<=0){ // Thématique de base
            String queryConcept = "INSERT INTO tax_classes(id, taxonomie, titreFR, " +
                    "descriptionFR, titreEN, descriptionEN, " +
                    "titreLemmaFR, descLemmaFR, titreLemmaEN, descLemmaEN) VALUES("+
                    id+", "+taxonomie+", '"+Codecs.escapeHTML(nomFR)+"', '"+Codecs.escapeHTML(descFR)+"', '"+
                    Codecs.escapeHTML(nomEN)+"', '"+Codecs.escapeHTML(descEN)+"', '"+
                    Codecs.escapeHTML(lemmasNomFR.toLemmas())+"', '"+
                    Codecs.escapeHTML(lemmasDescFR.toLemmas())+"', '"+
                    Codecs.escapeHTML(lemmasNomEN.toLemmas())+"', '"+
                    Codecs.escapeHTML(lemmasDescEN.toLemmas())+"');";
            theDB.executeInsertOrUpdate(queryConcept);
            storeLemmesFR(id, lemmasNomFR, lemmasDescFR);
            storeLemmesEN(id, lemmasNomEN, lemmasDescEN);
        } else { // Sous-thématique
            String queryConcept = "INSERT INTO tax_classes(id, taxonomie, titreFR, " +
                    "descriptionFR, titreEN, descriptionEN, " +
                    "titreLemmaFR, descLemmaFR, titreLemmaEN, descLemmaEN) VALUES("+
                    id+", "+taxonomie+", '"+Codecs.escapeHTML(nomFR)+"', '"+Codecs.escapeHTML(descFR)+"', '"+
                    Codecs.escapeHTML(nomEN)+"', '"+Codecs.escapeHTML(descEN)+"', '"+
                    Codecs.escapeHTML(lemmasNomFR.toLemmas())+"', '"+
                    Codecs.escapeHTML(lemmasDescFR.toLemmas())+"', '"+
                    Codecs.escapeHTML(lemmasNomEN.toLemmas())+"', '"+
                    Codecs.escapeHTML(lemmasDescEN.toLemmas())+"');";
            String queryRelation = "INSERT INTO tax_hierarchie(surClasse, " +
                    "sousClasse) VALUES("+
                    parent+", "+id+");";
            theDB.executeInsertOrUpdate(queryConcept);
            theDB.executeInsertOrUpdate(queryRelation);
            storeLemmesFR(id, lemmasNomFR, lemmasDescFR);
            storeLemmesEN(id, lemmasNomEN, lemmasDescEN);
        }
    }

    private void storeLemmesFR(int itemId, LemmaVector title, LemmaVector desc) throws NoBaseException {

        Map<LemmaInfos, Integer> lemmasCountTitle = title.toLemmasCount();
        Map<LemmaInfos, Integer> lemmasCountDesc = desc.toLemmasCount();
        // for each title lemma
        Vector<LemmaInfos> liste = title.getLemmas();
        for (int i = 0; i<liste.size(); i++) {
            String lemma = liste.elementAt(i).get_lemma();
            String lex = liste.elementAt(i).get_lex();
            if (lemmasCountDesc.containsKey(liste.elementAt(i))) { // dans le titre et dans la description
                try{
                    insertLemmaFR(itemId, lemma, lemmasCountTitle.get(liste.elementAt(i)), lemmasCountDesc.get(liste.elementAt(i)), lex);
                }catch (Exception ex){
                    //debug
                    System.out.println(String.format("Lemme title+desc insert problem :"+ex.getMessage()));
                }
            } else {
                try{
                    insertLemmaFR(itemId, lemma, lemmasCountTitle.get(liste.elementAt(i)), 0, lex);
                }catch (Exception ex){
                    //debug
                    System.out.println(String.format("Lemme title insert problem :"+ex.getMessage()));
                }
            }
        }
        // for each description lemma
        liste = desc.getLemmas();
        for (int i = 0; i<liste.size(); i++) {
            String lemma = liste.elementAt(i).get_lemma();
            String lex = liste.elementAt(i).get_lex();
            if (!lemmasCountTitle.containsKey(liste.elementAt(i))) {
                try{
                    insertLemmaFR(itemId, lemma, 0, lemmasCountDesc.get(liste.elementAt(i)), lex);
                }catch (Exception ex){
                    //debug
                    System.out.println(String.format("Lemme desc insert problem :"+ex.getMessage()));
                }
            }
        }
    }

    private void storeLemmesEN(int itemId, LemmaVector title, LemmaVector desc) throws NoBaseException {

        Map<LemmaInfos, Integer> lemmasCountTitle = title.toLemmasCount();
        Map<LemmaInfos, Integer> lemmasCountDesc = desc.toLemmasCount();
        // for each title lemma
        Vector<LemmaInfos> liste = title.getLemmas();
        for (int i = 0; i<liste.size(); i++) {
            String lemma = liste.elementAt(i).get_lemma();
            String lex = liste.elementAt(i).get_lex();
            if (lemmasCountDesc.containsKey(liste.elementAt(i))) { // dans le titre et dans la description
                try{
                    insertLemmaEN(itemId, lemma, lemmasCountTitle.get(liste.elementAt(i)), lemmasCountDesc.get(liste.elementAt(i)), lex);
                }catch (Exception ex){
                    //debug
                    System.out.println(String.format("Lemme title+desc insert problem :"+ex.getMessage()));
                }
            } else {
                try{
                    insertLemmaEN(itemId, lemma, lemmasCountTitle.get(liste.elementAt(i)), 0, lex);
                }catch (Exception ex){
                    //debug
                    System.out.println(String.format("Lemme title insert problem :"+ex.getMessage()));
                }
            }
        }
        // for each description lemma
        liste = desc.getLemmas();
        for (int i = 0; i<liste.size(); i++) {
            String lemma = liste.elementAt(i).get_lemma();
            String lex = liste.elementAt(i).get_lex();
            if (!lemmasCountTitle.containsKey(liste.elementAt(i))) {
                try{
                    insertLemmaEN(itemId, lemma, 0, lemmasCountDesc.get(liste.elementAt(i)), lex);
                }catch (Exception ex){
                    //debug
                    System.out.println(String.format("Lemme desc insert problem :"+ex.getMessage()));
                }
            }
        }
    }

    private void insertLemmaFR(int id, String lemma, int a, int b, String lex) throws NoBaseException {
        if (!unwantedLemma(lemma)) {
            String queryLemma = "INSERT INTO tax_lemmesfr(classe, lemme, " +
                    "occuTitre, occuDesc, nature) VALUES(" +
                    id + ", '" + Codecs.escapeHTML(lemma) + "', " + a + ", " + b +
                    ", '" + lex + "');";
            theDB.executeInsertOrUpdate(queryLemma);
        }
    }

    private void insertLemmaEN(int id, String lemma, int a, int b, String lex) throws NoBaseException {
        if (!unwantedLemma(lemma)) {
            String queryLemma = "INSERT INTO tax_lemmesen(classe, lemme, " +
                    "occuTitre, occuDesc, nature) VALUES(" +
                    id + ", '" + Codecs.escapeHTML(lemma) + "', " + a + ", " + b +
                    ", '" + lex + "');";
            theDB.executeInsertOrUpdate(queryLemma);
        }
    }

    private boolean unwantedLemma(String lemma) {
        //On n'utilise plus cette méthode qui élimine des lemmes utiles.
        //De toute façon, les lemmes sont éliminés par leur nature.
        return false;
        /*// aucun lemme de taille 1 n'est souhaitable (de toute façon, a/à/y sont éliminés ensuite)
        if(lemma.length()<2){
            return true;
        }
        // detection par le corpus de termes de la table ipri_lemmes_ignore
        if (ignoreLemma.contains(lemma)) {
            //System.out.println("lemme refusé: "+lemma);
            return true;
        }
        // elimination des valeurs numeriques extravagantes
        List weirdLemma = new ArrayList();
        weirdLemma.add("$");
        weirdLemma.add("&");
        weirdLemma.add("#");
        weirdLemma.add("+");
        weirdLemma.add("/");
        weirdLemma.add("@");
        weirdLemma.add("(");
        weirdLemma.add(")");
        weirdLemma.add("*");
        for (int i = 0; i < weirdLemma.size(); i++) {
            if (lemma.contains((CharSequence) weirdLemma.get(i))) {
                //System.out.println("lemme refusé : "+lemma);
                return true;
            }
        }
        return false;*/
    }

    /*private void getIgnoreLemma() throws SQLException {
        String query = String.format("SELECT lemme FROM ipri_lemmes_ignore");
        ResultSet rs = theDB.executeSelection(query);
        try {
            while (rs.next()) {
                ignoreLemma.add(rs.getString(1));
            }
            rs.close();
        } catch (SQLException e) {
            System.out.println("error retrieving lemmas to ignore");
            throw e;
        }
    }*/
}
